#ifndef __CExpGain__
#define __CExpGain__

//	===========================================================================

#include <audioeffectx.h>
#include <ECore.h>
#include <EGUI.h>
#include <EVST.h>

//	===========================================================================

/**
 * @namespace Exponent
 * @brief Main Exponent namespace
 */
namespace Exponent
{
	/**
	 * @namespace ExpGain
	 * @brief ExpGain namespace
	 */
	namespace ExpGain
	{
		/**
		 * @class CExpGain CExpGain.hpp
		 * @brief Example VSt plugin, very basic gain changer
		 *
		 * @date 28/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 *
		 * $Id: CExpGain.hpp,v 1.2 2007/03/03 02:59:53 paul Exp $
		 */
		class CExpGain : public CVstEffect
		{
			/** @cond */
			/*
			 * Make sure that you always include this at the top of your class declaration when using the Infinity API.
			 * It ensure that the run time type info for your class is correctly initialised
			 */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */


//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param audioMaster The audio master call back function
			 */
			CExpGain(audioMasterCallback audioMaster);

			/**
			 * Destruction
			 */
			~CExpGain();

//	===========================================================================

			/**
			 * Process
			 * @param input The input audio buffers
			 * @param output The output audio buffer
			 * @param numberOfSamples The number of samples to process
			 */
			virtual void process(float **input, float **output, VstInt32 numberOfSamples);

			/**
			 * Process Replacing
			 * @param output The output audio buffer
			 * @param numberOfSamples The number of samples to process
			 */
			virtual void processReplacing(float **input, float **output, VstInt32 numberOfSamples);

//	===========================================================================

			/**
			 * What can this plugin do
			 * @param text the opcode string as defined in the VSTSDK
			 * @retval -1 cant do, 0, dont know, 1 can do
			 * @see CVst
			 */
			virtual VstInt32 canDo(char *text);

			/**
			 * Get the output pin properties
			 * @param index The pin index
			 * @param properties On return are filled with the pin properties
			 * @retval bool True if filled properly, false otherwise
			 */
			virtual bool getOutputProperties(VstInt32 index, VstPinProperties* properties);

			/**
			 * Get the input pin properties
			 * @param index The pin index
			 * @param properties On return are filled with the pin properties
			 * @retval bool True if filled properly, false otherwise
			 */
			virtual bool getInputProperties(VstInt32 index, VstPinProperties *properties);

//	===========================================================================

			/**
			 * Set the parameter
			 * @param index The index of the controls
			 * @param value The value to give the control
			 */
			virtual void setParameter(VstInt32 index, float value);

			/**
			 * Get the parameter
			 * @param index The index of the control
			 * @retval flot The value of the parameter
			 */
			virtual float getParameter(VstInt32 index);

			/**
			 * Get the parameter label
			 * @param index The index of the controls
			 * @param label On return is filled with the label of the parameter
			 */
			virtual void getParameterLabel(VstInt32 index, char *label);

			/**
			 * Get the parameter display
			 * @param index The index of the controls
			 * @param text On return is filled with the string representing the parameter
			 */
			virtual void getParameterDisplay(VstInt32 index, char *text);

			/**
			 * Get the parameter name
			 * @param index The index of the controls
			 * @param text On return is filled with the name of the parameter
			 */
			virtual void getParameterName(VstInt32 index, char *text);

//	===========================================================================

		protected:

//	===========================================================================

			float m_gain;				/**< The gain of the plugin, in the range 0 - 1 */
		};
	}
}
#endif
